from mynumpy import *

def logpdf(z,loc,scale):
    return log(pdf(z,loc,scale))

def pdf(z,loc,scale):
    return (abs(z-loc) < scale/2).astype(float) / scale

def ppf(omega,loc,scale):
    return loc-scale/2 + scale*omega

def cdf(z,loc,scale):
    z_min = loc-scale/2
    z_max = loc+scale/2
    F = (z-z_min)/(scale)
    F[F<0]=0
    F[F>1]=1
    return F

if __name__ == '__main__':
    import seaborn as sns
    from matplotlib import pyplot as plt

    loc   = 1.5
    scale = 0.5

    omega = rand(100000)
    zs = ppf(omega,loc,scale)

    sns.kdeplot(zs,label='kde',bw=.02)

    z = arange(-5,5,.01)
    plt.plot(z,pdf(z,loc,scale))
    plt.savefig('uniform.pdf')